<?php

namespace IZON\Forms\Tests;

use Exception;

use PHPUnit\Framework\TestCase;

use IZON\Forms\Form;
use IZON\Forms\FormSet;

/**
 * test formulare
 * 
 * @covers FormSet
 */
class FormSetTest extends TestCase {
    
    /**
     * pridani podformularu do formulare
     */
    public function testAddForms() {
        $formSet = new FormSet();
        
        $form = new Form();
        $formSet->addForm($form, TestObject::class);
        
        // vraci stejny formular
        $gettedForm = $formSet->getForm();
        $this->assertSame($form, $gettedForm);
        
        $form2 = new Form();
        $formSet->addForm($form2, TestObject::class, ["form2"]);
        // vraci stejny formular
        $gettedForm2 = $formSet->getForm(["form2"]);
        $this->assertSame($form2, $gettedForm2);
        // form a form2 jsou ruzne
        $this->assertNotSame($form, $form2);
        
        // opakovane pridani formulare
        $this->expectException(\Exception::class);
        $formSet->addForm($form, TestObject::class);
        
//        $this->expectException(Exception::class);
        // opakovane pridani dinamickeho formulare se stejnym preffixem
        $formSet->addDinamicForm($form);
    }
    
    /**
     * pridani podformularu do formulare
     */
    public function testFormSetValues() {
        $formSet = new FormSet();
        
        $form = new Form();
        $form->addCharField("char");
        $formSet->addForm($form, TestObject::class);
        
        $form2 = new Form();
        $form2->addCharField("char");
        $formSet->addForm($form2, TestObject::class, ["prefix"]);
        
        $dinForm = new Form();
        $dinForm->addCharField("dinChar");
        $formSet->addDinamicFormDefinition($dinForm, InternalTestObject::class, ["dinPrefix"]);
        
        $values = [
            "char" => 'char',
            "prefix" => [
                'char' => 'char2'
            ],
            'dinPrefix' => [
                'index1' => [
                    'dinChar' => 'index1DinChar'
                ],
                2 => [
                    'dinChar' => '2DinChar'
                ],
            ]
        ];
        $formSet->setValues($values);
        
        $this->assertEquals('char', $formSet->getForm()->getField("char")->getValue());
        $this->assertEquals('char2', $formSet->getForm(['prefix'])->getField("char")->getValue());
        
        
        $this->assertEquals(2, $formSet->getDinamicFormsCount(['dinPrefix']));
        
        $dinForms = $formSet->getDinamicForms(["dinPrefix"]);
        $this->assertEquals('index1DinChar', $dinForms['index1']->getField("dinChar")->getValue());
        $this->assertEquals('2DinChar', $dinForms['2']->getField("dinChar")->getValue());
    }
    
    /**
     * pridani podformularu do formulare
     */
    public function testAddDinamicForms() {
        $formSet = new FormSet();
        
        $form = new Form();
        $formSet->addDinamicFormDefinition($form, InternalTestObject::class, ["dinPrefix"]);
        $this->assertSame($form, $formSet->getDinamicFormDefinition(["dinPrefix"]));
        
        // dinamicky formular nebyl naplnen, vraci se prazdny
        $gettedForms = $formSet->getDinamicForms(["dinPrefix"]);
        $this->assertEquals([], $gettedForms);
        
        // opakovane pridani formulare
        $this->expectException(\Exception::class);
        $formSet->addForm($form, TestObject::class);
        
        $this->expectException(Exception::class);
        // opakovane pridani dinamickeho formulare se stejnym preffixem
        $formSet->addDinamicFormDefinition($form, InternalTestObject::class, ["dinPrefix"]);
    }
}
