<?php

namespace IZON\Forms\Fields;

use Exception;

use IZON\Utils\Date;
use IZON\Forms\ValidationRule;

/**
 * Pole odpovidajici input text
 */
class DateTimeFiled extends BaseField {
    
    protected $dateFormat = "j.n.Y G:i";
    
    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params ??? pouzivat
     * @return PasswordField
     */
    public function __construct($name, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        
        // moznost zmenit dateFormat
        if( isset($params["dateFormat"]) ) {
            $this->dateFormat = $params["dateFormat"];
        }
        
        $rule = new ValidationRule();
        $rule->setMessage(_('Zadaná hodnota není platné datum a čas.'));

        $function = function(DateTimeFiled $field, $args = array()) {
            // neni pozadovano a je prazdne
            if( !$field->getRequired() && $this->getValue() == "" ) {
                return true;
            } else {
                $date = Date::createFromFormat($field->getDateFormat(), $field->getValue());
                return $date != false;
            }
        };
        $rule->setValidator($function);
        $this->addRule($rule);
        
        return $this;
    }
    
    public function parse() {
        if( !$this->required 
            && $this->value == "" ) { // je povoleno prazdne pole a pole je prazdne
            return NULL;
        } else {
            $date = Date::createFromFormat($this->dateFormat, $this->value);
            return $date;
        }
    }

    public function serialize($value) {
        if( $value instanceof Date ) { // parametr je objekt date
            $val = $value->format($this->dateFormat);
            $this->value = $val;
        } else {
            $this->value = '';
        }
    }
    
    function getDateFormat() {
        return $this->dateFormat;
    }

    /**
     * 
     * @param string $dateFormat
     */
    function setDateFormat($dateFormat) {
        // TODO: kontrola ze je korektni format data
        $this->dateFormat = $dateFormat;
        return $this;
    }
}
