<?php

namespace IZON\Forms\Tests;

use PHPUnit\Framework\TestCase;

use IZON\Forms\Form;

use IZON\Forms\Fields\EmailField;

/**
 * test formulare
 * 
 * @covers Form
 */
class FormTest extends TestCase {
    
    public function testEmailField() {
        // spravne se bytvari pres formular
        $form = new Form();
        $field = $form->addEmailField("email");
        $this->assertEquals(EmailField::class, get_class($field) );
        
        // je bezproblemu klonovatelne
        $field = new EmailField("email");
        $f2 = clone $field;
        $this->assertEquals(EmailField::class, get_class($f2) );
        
        // testi validace emailu
        $field->setValue("test@email.neco");
        $this->assertEquals([], $field->validate());
        $field->setValue("test@email:.neco");
        $this->assertEquals([_('Zadaná emailová adresa není platná.')], $field->validate());
    }
    
    public function testForm() {
        // pro spetnou kompatibilitu musi byt mozne vytvorit form s NULL prefixem
        $form = new Form(NULL);
        
        // vytvorit formular
        $form = $this->createTestForm();
        // prenastavit preffix
        $form->setPrefix(["prefix"]);
        
        
        /// test edit metody
        $form = $this->createTestForm();
        $testObject = new TestObject();
        $testObject->setChar('awwerwed te5t rtgryr6 ae');
        // edit pres property
        $form->edit($testObject);
        $this->assertEquals('awwerwed te5t rtgryr6 ae', $form->getField('char')->getValue());
        // edit pres gettery
        $form->edit($testObject, Form::EDIT_FLUSH_ACCESS_GETTERS_SETTERS);
        $this->assertEquals('awwerwed te5t rtgryr6 ae', $form->getField('char')->getValue());
        /// TODO: edit pomoci metody __call
        
        
        /// testovani flush
        $valuesArray = [
            "char" => 'awwerwed te5t rtgryr6 ae',
        ];
        $form->setValues($valuesArray);
        // flush pres property
        $testObject = new TestObject();
        $form->flush($testObject);
        $this->assertEquals($valuesArray["char"], $testObject->getChar());
        // flush pres settery
        $testObject = new TestObject();
        $form->flush($testObject, Form::EDIT_FLUSH_ACCESS_GETTERS_SETTERS);
        $this->assertEquals($valuesArray["char"], $testObject->getChar());
        /// TODO: flush pomoci metody __call
        
        
        /// nastaveni validatoru celeho formulare
        // validator musi byt callable
        $this->expectException(\Exception::class);
        $form->setValidator("sewwwe");
        // validator metoda musi mit prvni parametr Form
        // korektni validator
        $form->setValidator(function(Form $from) {
        });
        
        $clonedForm = clone $form;
    }
    
    /**
     * @return Form
     */
    protected function createTestForm() {
        // vytvorit formular
        $form = new Form();
        // prida pole pro testovani 
        $form->addCharField("char");
        
        return $form;
    }
}
