<?php

namespace IZON\Forms\Fields;

/**
 * Radio
 * 
 * inspiruje se z http://doc.nette.org/cs/2.3/forms#toc-addselect
 */
class RadioListField extends BaseField {
    
    /**
     * pouziva se pokud jsou $options objekty nebo pole
     * 
     * funkce, ktera z objektu vytahne hodnotu pouzivanou ve formulari jako value
     * @var callable 
     */
    protected $valueExtractor = NULL;
    
    /**
     * moznosti zobrazene v radiolistu
     * asociativni pole, kde key je navratova  hodnota a value je hodnota co se ma zobrazovat
     * @var array 
     */
    protected $options = [];
    
    public function __construct($name, $label = '', $params = array()) {
        $this->name         = $name;
        $this->label        = $label;
        $this->propertyName = $this->name;
        $this->errors       = array();
        return $this;
    }
    
    /**
     * pouziva se pokud jsou $options objekty nebo pole
     * 
     * funkce, ktera z objektu vytahne hodnotu pouzivanou ve formulari popis polozky
     * @var callable 
     */
    public function parse() {
        if ($this->nullOnEmpty && 
            empty(trim($this->value))) {
            return null;
        } else {
            return $this->value;
        }
    }
    
    function getOptions() {
      return $this->options;
    }

    function setOptions($options) {
      $this->options = $options;
      return $this;
    }

    
  public function serialize($value) {
    $this->value = $value;
  }

  protected $descriptionExtractor = NULL;
}
