<?php

namespace IZON\Forms;


class FormDefinition {
  /**
   * 
   * @var array pole objektu Form
   */
  protected $forms = [];
    
  public function __construct($param = array()) {
  }
  
  public function getForms() {
    return $this->forms;
  }
  /**
   * Prida formular $form do seznamu pod klicem $index<br>
   * Pokud je treba ve view zpristupnit pod jinym klicem nez defaultnim ('form'.ucfirst($index)) budiz zadan do $viewKey
   * 
   * @param mixed $index
   * @param \IZON\Forms\Form $form
   * @param string $viewKey pod jakym klicem bude formular dostupny ve view
   */
  public function addForm($index, Form $form, $viewKey = NULL) {
    $this->forms[$index] = array('form' => $form, 'viewKey' => is_null($viewKey) ? 'form'.ucfirst($index) : $viewKey );
  }
  /**
   * Stejne jako addForm, jen umozni pridat pod jeden klic vice formularu
   * 
   * @param type $index
   * @param array $form
   * @param type $viewKey
   */
  public function addForms($index, array $form, $viewKey = NULL) {
    $this->forms[$index] = array('form' => $form, 'viewKey' => is_null($viewKey) ? 'form'.ucfirst($index) : $viewKey );
  }
  /**
   * 
   * @param mixed $index
   * @return Form 
   */
  public function getForm($index) {
    return $this->forms[$index]['form'];
  }
  /**
   * Vrati formular s klicem, pod kterym ma byt dostupny ve view<br>
   * Pokud nebude zadany, vrati se jako klic index, pod kterym je ulozen
   * 
   * @param string $index
   * @return array
   */
  public function getFormWithViewKey($index) {
    return $this->forms[$index];
  }
  
  public function setForms($forms) {
    $this->forms = $forms;
  }
  /**
   * Odstrani jiz zaregistrovany formular
   * 
   * @param string $index
   */
  public function removeForm($index) {
    unset($this->forms[$index]);
  }


}
