<?php

namespace IZON\Forms\Fields;

use Exception;
use IZON\Forms\ValidationRule;

/**
 * Pole odpovidajici rozsahu cisel ve kterem se da posunovat
 * https://www.w3.org/wiki/HTML/Elements/input/range
 */
class IntegerRangeField extends BaseField {
    
    /**
     * @var integer minimalni hodnota, ktera muze byt do pole zadana
     */
    protected $minValue = FALSE;
    
    /**
     * @var integer maximalni hodnota, ktera muze byt do pole zadana
     */
    protected $maxValue = FALSE;
    
    /**
     * @var integer
     */
    protected $step = 1;

    /**
     * @var array pole s moznymi hodnotami soupatoru 
     */
    protected $valuesList = NULL;
    
    /**
     * 
     * @param string $name
     * @param string $label
     * @param array $params
     * @return PasswordField
     */
    public function __construct($name, $minValue, $maxValue, $label = '', $params = array()) {
        $this->name = $name;
        $this->label = $label;
        $this->propertyName = $this->name;
        $this->errors = array();
        
        if( $maxValue < $minValue ) {
            throw new Exception("minValue = ". $minValue ." nesmi byt vetsi nez maxValue = ". $maxValue);
        }
        
        $this->minValue = $minValue;
        $this->maxValue = $maxValue;
        
        $rule = new ValidationRule();
        $rule->setMessage(_('Zadaná hodnota je mimo rozsah.'));

        $function = function(IntegerRangeField $field, $args = array()) {
            return $field->getMinValue() <= $field->getValue() // je mensi nez minimum
                    && $field->getValue() <= $field->getMaxValue(); // je vetsi nez maximum
        };
        $rule->setValidator($function);
        $this->addRule($rule);
        
        return $this;
    }
    
    public function parse() {
        return $this->value;
    }

    public function serialize($value) {
        $this->value = $value;
    }
    
    function getMinValue() {
        return $this->minValue;
    }

    function getMaxValue() {
        return $this->maxValue;
    }
    
    public function getStep() {
      return $this->step;
    }

    public function setStep($step) {
        if( $step <= 0) {
            throw new Exception("Step nesmi byt nulovy nebo zaporny");
        }
        $this->step = $step;
    }


}
