<?php


namespace IZON\Filesystem;

use IZON\Filesystem\Exceptions\UndefinedFilesystemException;


class FilesystemSource implements FilesystemSourceInterface {

    protected FilesystemInterface $defaultFilesystem;

    /**
     * @var FilesystemInterface[]
     */
    protected array $filesystems = [];

    /**
     * FilesystemSource constructor.
     * @param FilesystemInterface $defaultFilesystem
     */
    public function __construct(FilesystemInterface $defaultFilesystem) {
        $this->defaultFilesystem = $defaultFilesystem;
    }

    /**
     * {@inheritDoc}
     */
    public function hasFilesystem(?string $uid = null): bool {
        return empty($uid) || array_key_exists($uid, $this->filesystems);
    }

    /**
     * {@inheritDoc}
     */
    public function getDefaultFilesystem(): FilesystemInterface {
        return $this->defaultFilesystem;
    }

    /**
     * {@inheritDoc}
     */
    public function getFilesystem(?string $uid = null): FilesystemInterface {
        if(empty($uid)) {
            return $this->defaultFilesystem;
        }
        if(!$this->hasFilesystem($uid)) {
            throw new UndefinedFilesystemException("Filesystem with uid '$uid' not registered");
        }
        return $this->filesystems[$uid];
    }

    /**
     * {@inheritDoc}
     */
    public function registerDefaultFilesystem(FilesystemInterface $filesystem): void {
        $this->defaultFilesystem = $filesystem;
    }

    /**
     * {@inheritDoc}
     */
    public function registerFilesystem(string $uid, FilesystemInterface $filesystem): void {
        $this->filesystems[$uid] = $filesystem;
        $filesystem->registerUID($uid);
    }
}
