<?php

namespace IZON\Filesystem;

use IZON\IO\FileInterface;
use IZON\IO\RasterImageInterface;
use League\Flysystem\FilesystemInterface as FlysystemFilesystemInterface;

interface FilesystemInterface extends FlysystemFilesystemInterface {

    public function getFilesystemUID(): ?string;

    public function registerUID(string $uid);

    /**
     * @param string|int $uid
     * @return FileInterface|RasterImageInterface
     */
    public function getFile($uid): FileInterface;

    /**
     * @return bool true if file system shoul not be written to
     */
    public function getReadonly(): bool;
}
