<?php

namespace IZON\Filesystem;


interface FilesystemSourceInterface {

    /**
     * returns true if has file system $uid registered or default file system if no $uid provided
     * @param string|null $uid
     * @return bool
     */
    public function hasFilesystem(?string $uid = null): bool;

    /**
     * @return FilesystemInterface
     */
    public function getDefaultFilesystem(): FilesystemInterface;

    /**
     * registers default file system
     * @param FilesystemInterface $filesystem
     * @return mixed
     */
    public function registerDefaultFilesystem(FilesystemInterface $filesystem): void;

    /**
     * returns file system registered under $uid
     * @param string|null $uid
     * @return FilesystemInterface
     */
    public function getFilesystem(?string $uid = null): FilesystemInterface;

    /**
     * registers file system under $uid
     * @param string $uid
     * @param FilesystemInterface $filesystem
     */
    public function registerFilesystem(string $uid, FilesystemInterface $filesystem): void;
}
