<?php


namespace IZON\Filesystem\Files;

use IZON\IO\Exceptions\UnsupportedRasterImageTypeException;
use IZON\IO\RasterImageInterface;

class RasterImage extends File implements  RasterImageInterface {

    protected $imageMetadata =  null;

    public function getPixelWidth(): int {
        $metadata = $this->getMetadata();
        if(array_key_exists('width', $metadata)) {
            return  $metadata['width'];
        }
        $this->initImageMetadata();
        return $this->imageMetadata['width'];
    }

    public function getPixelHeight(): int {
        $metadata = $this->getMetadata();
        if(array_key_exists('height', $metadata)) {
            return  $metadata['height'];
        }
        $this->initImageMetadata();
        return $this->imageMetadata['height'];
    }

    protected function initImageMetadata(): void {
        if( !is_array($this->imageMetadata) ) {
            $imageSize = getimagesizefromstring($this->getFileContents());
            if( $imageSize === false ) {
                throw new UnsupportedRasterImageTypeException('imagecreatefromstring cannot open image (fileUID='. $this->getFileUID().';originUID='. $this->getOriginUID() .'). If file type WebP use php7.4');
            }
            $this->imageMetadata = [
                'width' => $imageSize[0],
                'height' => $imageSize[1],
            ];
        }
    }
}
