<?php


namespace IZON\Filesystem;


use IZON\Filesystem\Files\File;
use IZON\Filesystem\Files\RasterImage;
use IZON\IO\FileInterface;
use League\Flysystem\FileNotFoundException;
use League\Flysystem\Filesystem as FlysystemFilesystem;

class Filesystem extends FlysystemFilesystem implements FilesystemInterface {

    const RASTER_IMAGE_MIME_TYPES = [
        'image/jpeg',
        'image/jpg',
        'image/png',
        'image/webp',
        'image/gif',
        'image/x-xbitmap', // XBM
        'image/bmp',
    ];

    /**
     * @var string
     */
    protected $filesystemUID;

    /**
     * @var bool
     */
    protected $readonly = false;


    public function getFilesystemUID(): ?string {
        return $this->filesystemUID;
    }

    public function registerUID(string $uid) {
        $this->filesystemUID = $uid;
    }

    public function getFile($uid): FileInterface {
        if(!$this->has($uid)) {
            throw new FileNotFoundException("File '$uid' not found in filesystem '{$this->filesystemUID}'");
        }
        $mime = $this->getMimetype($uid);
        if( in_array(mb_strtolower($mime), self::RASTER_IMAGE_MIME_TYPES) ) {
            return new RasterImage($this, $uid);
        }
        return new File($this, $uid);
    }

    /**
     * @return bool true if file system shoul not be written to
     */
    public function getReadonly(): bool {
        return true;
        // DOTO: shoud be read from filesystem adapter
    }

    /**
     * @param bool $readonly
     */
    public function setReadonly(bool $readonly): void {
        $this->readonly = $readonly;
    }
}
