<?php

namespace IZON\Filesystem;


interface FilesystemSourceInterface {

    /**
     * returns true if has file system $uid registred or default file system if no $uid provided
     * @param string|null $uid
     * @return bool
     */
    public function hasFilesystem(?string $uid = null): bool;

    /**
     * @return FilesystemInterface
     */
    public function getDefaultFilesystem(): FilesystemInterface;

    /**
     * returns file system refistred under $uid
     * @param string|null $uid
     * @return FilesystemInterface
     */
    public function getFilesystem(?string $uid = null): FilesystemInterface;

    /**
     *
     * @param FilesystemInterface $filesystem
     * @return mixed
     */
    public function registerDefaultFilesystem(FilesystemInterface $filesystem): void;

    /**
     * registers file system under $uid
     * @param string $uid
     * @param FilesystemInterface $filesystem
     */
    public function registerFilesystem(string $uid, FilesystemInterface $filesystem): void;
}
