<?php

namespace IZON\DI\Definition;

use DI\Definition\Definition;

/**
 * compatibility layer to unify older and newer versions of PHP-DI
 */
abstract class AbstractCompatDefinition implements Definition
{
    public function replaceNestedDefinitions(callable $replacer): void
    {
        $this->compatReplaceNestedDefinitions($replacer);
    }

    abstract public function compatReplaceNestedDefinitions(callable $replacer): void;

    public function __toString(): string
    {
        return $this->__compatToString();
    }

    abstract public function __compatToString(): string;
}
