<?php

/**
 * funkce pouzivane pri konfiguraci Dependency Injectin
 */

namespace IZON\DI;

use DI\Definition\EnvironmentVariableDefinition;
use DI\Definition\Helper\AutowireDefinitionHelper;
use DI\Definition\Helper\CreateDefinitionHelper;
use DI\Definition\Helper\DefinitionHelper;
use DI\Definition\Reference;
use DI\Definition\StringDefinition;
use DI\Definition\ValueDefinition;
use IZON\DI\Definition\Helper\CreateFactoryObjectDefinitionHelper;
use IZON\DI\Definition\Helper\FactoryDefinitionHelper as IZONFactoryDefinitionHelper;

if (!function_exists('IZON\DI\value')) {
    /**
     * Helper for defining an object.
     *
     * @deprecated use IZON\DI\DI::value instead
     *
     * @param mixed $value
     * @return ValueDefinition
     */
    function value($value): ValueDefinition
    {
        return DI::value($value);
    }
}

if (!function_exists('IZON\DI\create')) {
    /**
     * @deprecated use IZON\DI\DI::create instead
     *
     * @param null|string $className
     * @return CreateDefinitionHelper
     */
    function create(?string $className = null): CreateDefinitionHelper
    {
        return DI::create($className);
    }
}

if (!function_exists('IZON\DI\object')) {
    /**
     * @deprecated use IZON\DI\DI::autowire or IZON\DI\DI::create instead
     * @param null|string $className
     * @return AutowireDefinitionHelper
     */
    function object(?string $className = null): AutowireDefinitionHelper
    {
        return DI::autowire($className);
    }
}

if (!function_exists('IZON\DI\autowire')) {
    /**
     * @deprecated use IZON\DI\DI::autowire instead
     *
     * @param null|string $className
     * @return AutowireDefinitionHelper
     */
    function autowire(?string $className = null): AutowireDefinitionHelper
    {
        return DI::autowire($className);
    }
}

if (!function_exists('IZON\DI\factory')) {
    /**
     * @deprecated use IZON\DI\DI::factory instead
     *
     * Helper for defining a container entry using a factory function/callable.
     *
     * @param callable $factory
     *            The factory is a callable that takes the container as parameter
     *            and returns the value to register in the container.
     *
     * @return IZONFactoryDefinitionHelper
     */
    function factory($factory): IZONFactoryDefinitionHelper
    {
        // makes factory serializable
        return DI::factory($factory);
    }
}

if (!function_exists('IZON\DI\factoryBean')) {
    /**
     * Helper for defining factory an object.
     * @deprecated use DI::factoryObject instead
     */
    function factoryBean(?string $className = null): DefinitionHelper
    {
        return factoryObject($className);
    }
}

if (!function_exists('IZON\DI\factoryObject')) {
    /**
     * Helper for defining factory an object.
     * @deprecated use DI::factoryObject instead
     */
    function factoryObject(string $className, ?string $factoryMethodName = null): CreateFactoryObjectDefinitionHelper
    {
        return DI::factoryObject($className, $factoryMethodName);
    }
}

if (!function_exists('IZON\DI\get')) {
    /**
     * @deprecated use IZON\DI\DI::get instead
     *
     * Helper for referencing another container entry in an object definition.
     *
     * @param string $entryName
     *
     * @return Reference
     */
    function get(string $entryName): Reference
    {
        return DI::get($entryName);
    }
}

if (!function_exists('IZON\DI\env')) {
    /**
     * @deprecated use IZON\DI\DI::env instead
     *
     * Helper for referencing environment variables.
     *
     * @param string $variableName
     *            The name of the environment variable.
     * @param mixed $defaultValue
     *            The default value to be used if the environment variable is not defined.
     *
     * @return EnvironmentVariableDefinition
     */
    function env(string $variableName, $defaultValue = null): EnvironmentVariableDefinition
    {
        return DI::env($variableName, $defaultValue);
    }
}


if (!function_exists('IZON\DI\string')) {
    /**
     * @deprecated use IZON\DI\DI::string instead
     *
     * Helper for concatenating strings.
     *
     * Example:
     *
     *     'log.filename' => DI\string('{app.path}/app.log')
     *
     * @param string $expression A string expression. Use the `{}` placeholders to reference other container entries.
     *
     * @return StringDefinition
     *
     * @since 5.0
     */
    function string(string $expression): StringDefinition
    {
        return DI::string($expression);
    }
}
