<?php

namespace IZON\DI\Definition\Resolver;

use DI\Definition\Definition;
use DI\Definition\Resolver\DefinitionResolver;

/**
 * compatibility layer to unify older and newer versions of PHP-DI
 */
abstract class AbstractCompatDefinitionResolver implements DefinitionResolver
{
    /**
     * @inheritDoc
     */
    public function resolve(Definition $definition, array $parameters = [])
    {
        return $this->compatResolve($definition, $parameters);
    }

    abstract public function compatResolve(Definition $definition, array $parameters = []);
}
