<?php

/**
 * funkce pouzivane pri konfiguraci Dependency Injectin
 */

namespace IZON\DI;


use DI\Definition\Helper\AutowireDefinitionHelper;
use DI\Definition\Helper\CreateDefinitionHelper;
use DI\Definition\Helper\EnvironmentVariableDefinitionHelper;
use DI\Definition\Helper\ObjectDefinitionHelper;
use DI\Definition\Helper\StringDefinitionHelper;
use DI\Definition\Reference;
use DI\Definition\ValueDefinition;
use Exception;
use IZON\DI\Definition\Helper\CreateFactoryObjectDefinitionHelper;
use DI\Definition\Helper\FactoryDefinitionHelper;
use DI\Definition\EnvironmentVariableDefinition;
use ReflectionClass;


if( !function_exists('IZON\DI\value') ) {

    /**
     * Helper for defining an object.
     *
     * @param mixed $value
     *
     * @return ValueDefinition
     */
    function value($value): ValueDefinition {
        return \DI\value($value);
    }

}

if( !function_exists('IZON\DI\create') ) {

    /**
     * @param null|string $className
     * @return CreateDefinitionHelper
     */
    function create(?string $className = null): CreateDefinitionHelper {
        return \DI\create($className);
    }
}

if( !function_exists('IZON\DI\object') ) {

    /**
     * @deprecated use autowire on create instead
     * @param null|string $className
     * @return CreateDefinitionHelper
     */
    function object(?string $className = null): AutowireDefinitionHelper {
        return \DI\autowire($className);
    }
}

if( !function_exists('IZON\DI\autowire') ) {

    /**
     *
     * @param null|string $className
     * @return AutowireDefinitionHelper
     */
    function autowire(?string $className = null): AutowireDefinitionHelper {
        return \DI\autowire($className);
    }
}

if( !function_exists('IZON\DI\factory') ) {

    /**
     * Helper for defining a container entry using a factory function/callable.
     *
     * @param callable $factory
     *            The factory is a callable that takes the container as parameter
     *            and returns the value to register in the container.
     *
     * @return FactoryDefinitionHelper
     */
    function factory($factory): FactoryDefinitionHelper {
        // makes factory serializable
        return new Definition\Helper\FactoryDefinitionHelper($factory);
    }

}

if (!function_exists('IZON\DI\factoryObject')) {

    /**
     * slouzi k vytvoreni factory beanu ktery vytvori konecny objekt
     * @param string|null $className
     * @return ObjectDefinitionHelper
     */
    function factoryObject($className = null, $factoryClassName = null) {
        $reflector = new ReflectionClass($factoryClassName);
        if( !$reflector->implementsInterface(FactoryObject::class) ) {
            throw new Exception("Must implement ". FactoryObject::class);
        }

        $createDefinitionHelper = new CreateFactoryObjectDefinitionHelper($className, $factoryClassName);
//        $createDefinitionHelper->
        return $createDefinitionHelper;
    }

}

if (!function_exists('IZON\DI\get')) {

    /**
     * Helper for referencing another container entry in an object definition.
     *
     * @param string $entryName
     *
     * @return Reference
     */
    function get(string $entryName): Reference {
        return \DI\get($entryName);
    }

}

if (!function_exists('IZON\DI\env')) {

    /**
     * Helper for referencing environment variables.
     *
     * @param string $variableName
     *            The name of the environment variable.
     * @param mixed $defaultValue
     *            The default value to be used if the environment variable is not defined.
     *
     * @return EnvironmentVariableDefinitionHelper
     */
    function env(string $variableName, $defaultValue = null): EnvironmentVariableDefinition {
        return \DI\env($variableName, $defaultValue);
    }

}


if (! function_exists('IZON\DI\string')) {
    /**
     * Helper for concatenating strings.
     *
     * Example:
     *
     *     'log.filename' => DI\string('{app.path}/app.log')
     *
     * @param string $expression A string expression. Use the `{}` placeholders to reference other container entries.
     *
     * @return StringDefinitionHelper
     *
     * @since 5.0
     */
    function string(string $expression): \DI\Definition\StringDefinition {
        return \DI\string($expression);
    }
}
