<?php

namespace IZON\DI\Definition\Resolver;

use DI\Definition\Definition;
use DI\Definition\ObjectDefinition;
use DI\Definition\Resolver\ObjectCreator;
use IZON\DI\FactoryObject;

/**
 * resolves FactoryObject as factory and calls getObject on it to create the object
 */
class FactoryObjectObjectCreator extends ObjectCreator
{
    /**
     * Resolve a class definition to a value.
     *
     * This will create a new instance of the class using the injections points defined.
     *
     * @param ObjectDefinition $definition
     *
     * {@inheritdoc}
     */
    public function resolve(Definition $definition, array $parameters = [])
    {
        $instance = parent::resolve($definition, $parameters);

        // je factory bean tak je potreba vratit jeko instanci
        if ($instance instanceof FactoryObject) {
            $instance = $instance->getObject();
        }

        return $instance;
    }
}
