<?php

namespace IZON\DI\Definition\Helper;

use Closure;
use DI\Definition\DecoratorDefinition;
use DI\Definition\FactoryDefinition;
use DI\Definition\Helper\FactoryDefinitionHelper as DIFactoryDefinitionHelper;
use Opis\Closure\SerializableClosure;

/**
 * reimplements \DI\Definition\Helper\FactoryDefinitionHelper to be serializable
 */
class FactoryDefinitionHelper extends DIFactoryDefinitionHelper
{
    /**
     * @var string
     */
    protected $isClousure = false;
    /**
     * @var mixed
     */
    protected $factorySerialized = null;
    /**
     * @var callable
     */
    private $factory;
    /**
     * @var bool
     */
    private $decorate;
    /**
     * @var array
     */
    private $parameters = [];

    /**
     * @param callable $factory
     * @param bool $decorate Is the factory decorating a previous definition?
     */
    public function __construct($factory, bool $decorate = false)
    {
        parent::__construct($factory, $decorate);
        $this->factory = $factory;
        $this->decorate = $decorate;
        // serialize clousure
        if ($this->factory instanceof Closure) {
            $this->isClousure = true;
        }
    }

    /**
     * @param string $entryName Container entry name
     * @return FactoryDefinition
     */
    public function getDefinition($entryName)
    {
        if ($this->decorate) {
            return new DecoratorDefinition($entryName, $this->factory, $this->parameters);
        }

        return new FactoryDefinition($entryName, $this->factory, $this->parameters);
    }

    /**
     * Defines arguments to pass to the factory.
     *
     * Because factory methods do not yet support annotations or autowiring, this method
     * should be used to define all parameters except the ContainerInterface and RequestedEntry.
     *
     * Multiple calls can be made to the method to override individual values.
     *
     * @param string $parameter Name or index of the parameter for which the value will be given.
     * @param mixed $value Value to give to this parameter.
     *
     * @return $this
     */
    public function parameter($parameter, $value)
    {
        $this->parameters[$parameter] = $value;

        return $this;
    }

    /**
     * pripravit objekt pro serializaci
     * @return array ktere property se maji serializovat
     */
    public function __sleep()
    {
        // serialize clousure
        if ($this->factory instanceof Closure) {
            $this->factorySerialized = new SerializableClosure($this->factory);
        } else {
            $this->factorySerialized = $this->factory;
        }

        return ["factorySerialized", "isClousure", "decorate"];
    }

    /**
     * propublid objekt
     */
    public function __wakeup()
    {
        if ($this->isClousure) {
            $this->factory = $this->factorySerialized->getClosure();
        } else {
            $this->factory = $this->factorySerialized;
        }
    }
}
