<?php

namespace IZON\DI\Definition\Resolver;

use DI\Definition\Definition;
use DI\Definition\Resolver\ObjectCreator;

use \IZON\DI\FactoryBean;

/**
 * Description of FactoryBeanResolver
 *
 * @author drymld
 */
class FactoryBeanObjectCreator extends ObjectCreator {

    /**
     * Resolve a class definition to a value.
     *
     * This will create a new instance of the class using the injections points defined.
     *
     * @param ClassDefinition $definition
     *
     * {@inheritdoc}
     */
    public function resolve(Definition $definition, array $parameters = array()) {
        $instance = parent::resolve($definition, $parameters);
        
        // je factory bean tak je potreba vratit jeko instanci
        if( $instance instanceof FactoryBean ) {
            $instance = $instance->getObject();
        }
        
        return $instance;
    }

}
