<?php
namespace IZON\DI\Definition\Helper;

use Exception;
use Closure;

use DI\Definition\DecoratorDefinition;
use DI\Definition\FactoryDefinition;

/**
 * reimplements \DI\Definition\Helper\FactoryDefinitionHelper to be serializable
 */
class FactoryDefinitionHelper extends \DI\Definition\Helper\FactoryDefinitionHelper {
    
    /**
     * @var \SuperClosure\Serializer|null serializator na clousure
     */
    protected static $clousureSerializer =  NULL;

    /**
     * @var Closure
     */
    private $factory;

    /**
     * @var string|null serializovana factory 
     */
    private $factorySerialized = NULL;

    /**
     * @var string|null
     */
    private $scope;

    /**
     * @var bool
     */
    private $decorate;
    
    /**
     * @param Closure $factory
     * @param bool     $decorate Is the factory decorating a previous definition?
     */
    public function __construct($factory, $decorate = false) {
        parent::__construct($factory, $decorate);
        $this->factory = $factory;
        $this->decorate = $decorate;
    }
    
    /**
     * Defines the scope of the entry.
     *
     * @param string $scope
     *
     * @return FactoryDefinitionHelper
     */
    public function scope($scope) {
        $this->scope = $scope;

        return $this;
    }

    /**
     * @param string $entryName Container entry name
     * @return FactoryDefinition
     */
    public function getDefinition($entryName) {
        if ($this->decorate) {
            return new DecoratorDefinition($entryName, $this->factory, $this->scope);
        }

        return new FactoryDefinition($entryName, $this->factory, $this->scope);
    }
    
    /**
     * pripravit objekt pro serializaci
     * @return array ktere property se maji serializovat
     */
    public function __sleep() {
        if( !class_exists(\SuperClosure\Serializer::class) ) {
            throw new Exception("Pro serializaci ". FactoryDefinitionHelper::class ." je potreba ". \SuperClosure\Serializer::class);
        }
        // inicializace serializatoru
        if( self::$clousureSerializer == NULL ) {
            self::$clousureSerializer = new \SuperClosure\Serializer();
        }
        
        // serialize clousure
        if( $this->factory instanceof \Closure ) {
            $this->factorySerialized = self::$clousureSerializer->serialize($this->factory);
        }
        
        return ["factorySerialized", "scope", "decorate"];
    }
    
    /**
     * propublid objekt
     */
    public function __wakeup() {
        if( !class_exists(\SuperClosure\Serializer::class) ) {
            throw new Exception("Pro serializaci ". FactoryDefinitionHelper::class ." je potreba ". \SuperClosure\Serializer::class);
        }
        // inicializace serializatoru
        if( self::$clousureSerializer == NULL ) {
            self::$clousureSerializer = new \SuperClosure\Serializer();
        }
        
        if( $this->factorySerialized !== null ) {
            // deserialize
            $this->factory = self::$clousureSerializer->unserialize($this->factorySerialized);
        }
    }
}
