<?php

namespace IZON\DI\Tests;

use PHPUnit\Framework\TestCase;

use function IZON\DI\object;
use function IZON\DI\get;
use function IZON\DI\factoryBean;
use function IZON\DI\factory;
use function IZON\DI\string;

use IZON\DI\ContainerBuilder;

use IZON\DI\Tests\Utils\InnerObject;
use IZON\DI\Tests\Utils\OuterObject;
use IZON\DI\Tests\Utils\TestFactoryBean;

/**
 * @covers ContainerBuilder
 */
class DiBuildContainerTest extends TestCase {
    
    public function testBuildContainer() {
        $stringValue = 'string value';
        $numberValue = 42;
        $definition = [
            "string" => $stringValue,
            "number" => $numberValue,
            'innerObject' => object(InnerObject::class),
            'outerObject' => object(OuterObject::class)
                ->constructor(get('innerObject'))
                ->method("setStringValue", get("string")),
            'factoryOuter' => factory(function(InnerObject $iner) {
                    return new OuterObject($iner);
            }),
            'stringDefinition' => string("{string}/sub"),
            'aliasOuter' => get('outerObject'),
        ];
        
        $builder = new ContainerBuilder();
        $builder->addDefinitions($definition);
        $container = $builder->build();
        
        $this->assertEquals($stringValue, $container->get("string"));
        $this->assertEquals($numberValue, $container->get("number"));
        $innerObject = $container->get("innerObject");
        $outerObject = $container->get("outerObject");
        $this->assertSame($innerObject, $outerObject->getInnerObject());
        $this->assertEquals($stringValue, $outerObject->getStringValue());
        $factoryObject = $container->get("factoryOuter");
        $this->assertInstanceOf(OuterObject::class, $factoryObject);
        $stringDefinition = $container->get("stringDefinition");
        $this->assertEquals($stringValue .'/sub', $stringDefinition);
        $aliasOuter = $container->get("aliasOuter");
        $this->assertSame($outerObject, $aliasOuter);
    }
    
    public function testFactoryBean() {
        $definition = [
            'factoryBean' => factoryBean(TestFactoryBean::class),
        ];
        
        $builder = new ContainerBuilder();
        $builder->addDefinitions($definition);
        $container = $builder->build();
        
        $innerObject = $container->get('factoryBean');
        $this->assertInstanceOf(InnerObject::class, $innerObject);
    }
    
    public function testAutoResolve() {
        $definition = [
            InnerObject::class => object(InnerObject::class),
            'outerObject' => object(OuterObject::class),
        ];
        
        $builder = new ContainerBuilder();
        $builder->addDefinitions($definition);
        $container = $builder->build();
        
        $innerObject = $container->get(InnerObject::class);
        $outerObject = $container->get("outerObject");
        $this->assertSame($innerObject, $outerObject->getInnerObject());
    }
}
