<?php

/**
 * funkce pouzivane pri konfiguraci Dependency Injectin
 */

namespace IZON\DI;

use DI\Definition\EntryReference;
use DI\Definition\Helper\EnvironmentVariableDefinitionHelper;
use DI\Definition\Helper\ObjectDefinitionHelper;
use DI\Definition\Helper\StringDefinitionHelper;
use DI\Definition\Helper\ValueDefinitionHelper;
use \Exception;
use IZON\DI\Definition\Helper\FactoryDefinitionHelper;


if( !function_exists('IZON\DI\value') ) {

    /**
     * Helper for defining an object.
     *
     * @param mixed $value
     *
     * @return ValueDefinitionHelper
     */
    function value($value) {
        return \DI\value($value);
    }

}

if( !function_exists('IZON\DI\object') ) {

    /**
     * 
     * @param string $className
     * @return ObjectDefinitionHelper
     */
    function object($className = null) {
        return \DI\object($className);
    }

}

if( !function_exists('IZON\DI\factory') ) {

    /**
     * Helper for defining a container entry using a factory function/callable.
     *
     * @param callable $factory
     *            The factory is a callable that takes the container as parameter
     *            and returns the value to register in the container.
     *            
     * @return FactoryDefinitionHelper
     */
    function factory($factory) {
        return new FactoryDefinitionHelper($factory);
    }

}

if (!function_exists('IZON\DI\factoryBean')) {

    /**
     * slouzi k vytvoreni factory beanu ktery vytvori konecny objekt
     * @param string|null $className
     * @return ObjectDefinitionHelper
     */
    function factoryBean($className = null) {
        $reflector = new \ReflectionClass($className);
        if (!$reflector->implementsInterface(FactoryBean::class)) {
            throw new Exception("Musi byt instanci tridy \IZON\DI\FactoryBean");
        }
        return \DI\object($className);
    }

}

if (!function_exists('IZON\DI\get')) {

    /**
     * Helper for referencing another container entry in an object definition.
     *
     * @param string $entryName
     *
     * @return EntryReference
     */
    function get($entryName) {
        return \DI\get($entryName);
    }

}

if (!function_exists('IZON\DI\link')) {

    /**
     * Helper for referencing another container entry in an object definition.
     *
     * @param string $entryName            
     *
     * @return EntryReference
     */
    function link($entryName) {
        return \DI\link($entryName);
    }

}

if (!function_exists('IZON\DI\env')) {

    /**
     * Helper for referencing environment variables.
     *
     * @param string $variableName
     *            The name of the environment variable.
     * @param mixed $defaultValue
     *            The default value to be used if the environment variable is not defined.
     *            
     * @return EnvironmentVariableDefinitionHelper
     */
    function env($variableName, $defaultValue = null) {
        return \DI\env($variableName, $defaultValue);
    }

}


if (! function_exists('IZON\DI\string')) {
    /**
     * Helper for concatenating strings.
     *
     * Example:
     *
     *     'log.filename' => DI\string('{app.path}/app.log')
     *
     * @param string $expression A string expression. Use the `{}` placeholders to reference other container entries.
     *
     * @return StringDefinitionHelper
     *
     * @since 5.0
     */
    function string($expression)
    {
        return \DI\string($expression);
    }
}