<?php

namespace IZON\DB\Utils;

use Doctrine\Common\Collections\Collection;
use IZON\Utils\ArrayUtils;

/**
 * utils for working with doctrine Collections
 * @package IZON\DB\Utils
 */
class CollectionUtils
{
    /**
     * replaces all elements in $destination with elements from $source
     * @param Collection $destination
     * @param iterable $source
     */
    public static function replaceAll(Collection $destination, iterable $source): void
    {
        // extract elements from iterable to new array to prevent cleaning of elements from $source if $source and destination are the same
        $sourceArray = ArrayUtils::toArray($source);
        $destination->clear();
        self::addAll($destination, $sourceArray);
    }

    /**
     * adds all elements from $source to $destination
     * @param Collection $destination
     * @param iterable $source
     */
    public static function addAll(Collection $destination, iterable $source): void
    {
        foreach ($source as $sourceItem) {
            $destination->add($sourceItem);
        }
    }
}
