<?php

namespace IZON\DB\Types\TypeRegistrars;

/**
 * only registers $typeClass under $typeName
 */
class SimpleTypeRegistrar implements TypeRegistrarInterface
{
    /**
     * @var string
     */
    protected $typeName;

    /**
     * @var string
     */
    protected $typeClass;


    /**
     * @param string $typeName
     * @param string $typeClass
     */
    public function __construct(string $typeName, string $typeClass)
    {
        $this->typeName = $typeName;
        $this->typeClass = $typeClass;
    }


    /**
     * @return string type name to register type under
     */
    public function getTypeName(): string
    {
        return $this->typeName;
    }

    /**
     * @return string class to handle type
     */
    public function getTypeClass(): string
    {
        return $this->typeClass;
    }

    /**
     * @inheritDoc
     */
    public function initType(): void
    {
        // does no additional registration
    }
}
