<?php

namespace IZON\DB\Repository;

use IZON\DB\Paginator\PageContentInterface;
use IZON\DB\Paginator\PaginatorConfigInterface;

/**
 * RespositoryInterface
 * Provides interface for manipulating with data of Entity using
 * paginator mechanism an custom queries.
 *
 * @template T of object
 */
interface RepositoryInterface
{
    /**
     *
     * @param int $pageSize
     * @return PaginatorConfigInterface
     */
    public function createDefaultPaginatorConfig(int $pageSize): PaginatorConfigInterface;

    /**
     *
     * @param PaginatorConfigInterface $paginatorConfig
     * @return PageContentInterface<T>
     */
    public function paginate(PaginatorConfigInterface $paginatorConfig): PageContentInterface;
}
