<?php

namespace IZON\DB\QueryParams;

/**
 * QueryParamsInterface
 * Encapsulates parameters passed to query factory methods for creating query.
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface QueryParamsInterface
{
    /**
     * @return array<string, mixed>
     */
    public function getParameters(): array;

    /**
     * @return array<string, mixed>
     */
    public function getParameterNames(): array;

    /**
     * @param string $paramName
     * @return bool
     */
    public function hasParameter(string $paramName): bool;

    /**
     * @param string $paramName
     * @return mixed
     */
    public function getParameter(string $paramName);

    /**
     *
     * @param string $paramName
     * @param mixed $value
     */
    public function putParameter(string $paramName, $value);

    /**
     * @return array<string, mixed>
     */
    public function getControlParameters();

    /**
     * @return array<string, string>
     */
    public function getControlParameterNames(): array;

    /**
     * @param string $paramName
     * @return bool
     */
    public function hasControlParameter(string $paramName): bool;

    /**
     * @param string $paramName
     * @return mixed
     */
    public function getControlParameter(string $paramName);

    /**
     * @param string $paramName
     * @param mixed $value
     */
    public function putControlParameter(string $paramName, $value);

    /**
     * @return OrderBy[]
     */
    public function getOrders(): array;

    /**
     * @param string $orderName
     * @param string $orientation
     */
    public function addOrder(string $orderName, string $orientation);

    /**
     * @param OrderBy $orderBy
     */
    public function addOrderBy(OrderBy $orderBy);
}
