<?php

namespace IZON\DB\QueryFactoryReader;

use Doctrine\ORM\Mapping\ClassMetadata;
use IZON\DB\QueryFactory\QueryFactoryInterface;

/**
 * Reads queryFactory config and initialized query factories from it
 *
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface QueryFactoryConfigReaderInterface
{
    /**
     * @param ClassMetadata $classMetadata
     * @param string $queryName
     * @return QueryFactoryInterface
     */
    public function getQueryFactory(ClassMetadata $classMetadata, string $queryName): QueryFactoryInterface;


    //    public function getDefaultQueryFactory(string $className, ClassMetadata $classMetadata): QueryFactoryInterface;
}
