<?php

namespace IZON\DB\QueryFactory;

use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\EntityManagerInterface;
use IZON\DB\Paginator\PaginatorConfigInterface;
use IZON\DB\QueryParams\QueryParamsInterface;

/**
 * QueryFactoryInterface
 * Provides factory interface for query creation
 * @author Aleš Kopecký <kopecky@izon.cz>
 * @author IZON s.r.o. <info@izon.cz>
 */
interface QueryFactoryInterface
{
    public const DEFAULT_QUERY_NAME = PaginatorConfigInterface::DEFAULT_QUERY_NAME;

    /**
     * @return string returns query name query factory creates
     */
    public function getQueryName(): string;

    /**
     * @param EntityManagerInterface $em
     * @param QueryParamsInterface $queryParams
     * @return AbstractQuery
     */
    public function getQuery(EntityManagerInterface $em, QueryParamsInterface $queryParams): AbstractQuery;

    /**
     * @return string[] regexes defining parameter names
     */
    public function getParameterDefinitionNames(): array;

    /**
     *
     * @return string[] regexes defining control parameters to use for construction of a query, not passed to db
     */
    public function getControlParameterDefinitionNames(): array;

    /**
     *
     * @return string[] names of orderings that can be used in a query
     */
    public function getOrderDefinitions(): array;
}
