<?php

namespace IZON\DB\Paginator;

use IZON\DB\QueryParams\OrderBy;
use IZON\DB\QueryParams\QueryParams;

/**
 * PaginatorConfigInterface
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface PaginatorConfigInterface
{
    public const DEFAULT_PAGE_SIZE = 100;

    public const DEFAULT_QUERY_NAME = '_default';

    /**
     * @param int $pageSize
     */
    public function setPageSize(int $pageSize);

    /**
     * @return int
     */
    public function getPageSize(): int;

    /**
     * @return string
     */
    public function getQueryName(): string;

    /**
     * @param string $propertyName
     * @return bool
     */
    public function hasParameter(string $propertyName): bool;

    /**
     * @param string $paramName
     * @param mixed $paramValue
     */
    public function putParameter(string $paramName, $paramValue);

    /**
     * @param string $paramName
     * @return mixed
     */
    public function getParameter(string $paramName);

    /**
     * @param string $paramName
     */
    public function removeParameter(string $paramName);

    /**
     * @return array
     */
    public function getParameters(): array;

    /**
     * @return OrderBy[]
     */
    public function getOrders(): array;

    /**
     * @param OrderBy $orderName
     */
    //    public function addOrderBy(OrderBy $orderBy);

    /**
     * Sets ordering by given property and given direction.
     *
     * @param string $orderName
     * @param string $direction OrderBy::ORDER_ASC|OrderBy::ORDER_SESC
     */
    public function addOrder(string $orderName, string $direction);

    /**
     * Clears currently defined orders.
     */
    public function clearOrders();

    /**
     * @param string $orderName
     *
     * Checks if ordering can be set fo given property.
     */
    public function isOrder(string $orderName): bool;

    /**
     * converts paginator config to QueryParams
     * @return QueryParams
     */
    public function toQueryParams(): QueryParams;

    public function setFirstResult(int $firstResult);

    public function getFirstResult(): int;
}
