<?php

namespace IZON\DB\Paginator;

/**
 * strankovac vysledku, ktery obsahuje pozadovanou stranku (jeji prvky)
 * pocet stranek, kolikata stranka to je atd.
 * @template E of object
 * @implements PageContentInterface<E>
 */
class PageContent implements PageContentInterface
{
    /**
     * kompletni mnozstli vysledku bez strankovani
     */
    protected int $totalCount;

    /**
     * zadana velikost stranky, pro kterou se melo strankovat
     */
    protected int $maxPageSize;

    /**
     * @var array<int, E> prvky prave aktivni stranky
     */
    protected array $page;

    /**
     * @var int[] indexy jednotlivych stranek
     */
    protected array $pageIndices;


    public function __construct(int $totalCount, int $maxPageSize, array $page)
    {
        $this->totalCount = $totalCount;
        $this->maxPageSize = $maxPageSize;
        $this->page = $page;

        $this->pageIndices = [];

        if ($this->totalCount != 0 && $this->maxPageSize != 0) {
            for ($i = 0; $i <= $totalCount; $i = $i + $maxPageSize) {
                $this->pageIndices[] = $i;
            }
        } else {
            $this->pageIndices[] = 0;
        }
    }

    public function getPage(): array
    {
        return $this->page;
    }

    public function getMaxPageSize()
    {
        return $this->maxPageSize;
    }

    public function getTotalCount(): int
    {
        return $this->totalCount;
    }

    public function getPageIndices()
    {
        return $this->pageIndices;
    }
}
