<?php


namespace IZON\DB\Extensions\Functions;

use Doctrine\ORM\Query\AST\Functions\FunctionNode;
use Doctrine\ORM\Query\Parser;
use Doctrine\ORM\Query\SqlWalker;
use Doctrine\ORM\Query\TokenType;

class StringEmpty extends FunctionNode
{
    public $string;

    public function getSql(SqlWalker $sqlWalker): string
    {
        return 'LENGTH(' . $sqlWalker->walkStringPrimary($this->string) . ') = 0';
    }

    public function parse(Parser $parser): void
    {
        $parser->match(TokenType::T_IDENTIFIER);
        $parser->match(TokenType::T_OPEN_PARENTHESIS);
        $this->string = $parser->StringPrimary();
        $parser->match(TokenType::T_CLOSE_PARENTHESIS);
    }
}
