<?php


namespace IZON\DB\Extensions\Functions;

use Doctrine\ORM\Query\AST\Functions\FunctionNode;
use Doctrine\ORM\Query\Parser;
use Doctrine\ORM\Query\SqlWalker;
use Doctrine\ORM\Query\TokenType;

class IsNull extends FunctionNode
{
    public $argument;

    public function getSql(SqlWalker $sqlWalker): string
    {
        return $sqlWalker->walkArithmeticPrimary($this->argument) . ' IS NULL';
    }

    public function parse(Parser $parser): void
    {
        $parser->match(TokenType::T_IDENTIFIER);
        $parser->match(TokenType::T_OPEN_PARENTHESIS);
        $this->argument = $parser->ArithmeticPrimary();
        $parser->match(TokenType::T_CLOSE_PARENTHESIS);
    }
}
