<?php

namespace IZON\DB\EntityManager;

use Doctrine\Common\EventManager;
use Doctrine\DBAL\DriverManager;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\Decorator\EntityManagerDecorator;
use Doctrine\ORM\EntityManager as DoctrineEntityManager;
use Doctrine\ORM\EntityManagerInterface as DoctrineEntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Exception\ORMException;
use InvalidArgumentException;
use IZON\DB\ConnectionInterface;
use IZON\DB\EntityManagerInterface;

/**
 * {inheritDoc}
 *
 * @author Lukáš Linhart
 */
class EntityManager extends EntityManagerDecorator implements EntityManagerInterface
{
    final public function __construct(DoctrineEntityManagerInterface $wrapped)
    {
        parent::__construct($wrapped);
    }

    /**
     * create method overridden from doctrine, because of not static creating of instance
     *
     * @param array|ConnectionInterface $connection An array with the connection parameters or an existing Connection instance.
     * @param Configuration $config The Configuration instance to use.
     * @param EventManager|null $eventManager The EventManager instance to use.
     *
     * @return EntityManager The created EntityManager.
     *
     * @throws InvalidArgumentException
     * @throws ORMException
     */
    public static function create($connection, Configuration $config, ?EventManager $eventManager = null)
    {
        if (is_array($connection)) {
            $connection = DriverManager::getConnection($connection, $config, $eventManager);
        }
        $connection = new DoctrineEntityManager($connection, $config, $eventManager);
        return new static($connection);
    }

    /**
     * @template EC of object
     * @param class-string<EC> $className
     * @return EntityRepository<EC>
     */
    public function getRepository(string $className): EntityRepository
    {
        return parent::getRepository($className);
    }
}
