<?php

namespace IZON\DB\EntityManager;

use Doctrine\ORM\Configuration as ORMConfiguration;

/**
 * additional config for db connection
 */
class Configuration extends ORMConfiguration
{
    /// generated getters and setters
    /**
     *
     * @return string|null where to store temoporary files generated for repositories
     */
    public function getRepositoryProxiesDir(): ?string
    {
        return $this->attributes['repositoryProxiesDir'] ?? null;
    }

    /**
     *
     * @param string|null $repositoryProxiesDir where to store temoporary files generated for repositories
     */
    public function setRepositoryProxiesDir(?string $repositoryProxiesDir)
    {
        $this->attributes['repositoryProxiesDir'] = $repositoryProxiesDir;
    }
}
