<?php

namespace IZON\DB\Connections;

use Doctrine\DBAL\Configuration as DBALConfiguration;

/**
 * additional config for db connection
 */
class Configuration extends DBALConfiguration
{
    protected ?string $proxyDir = null;

    /// generated getters and setters

    /**
     *
     * @return string|null ?where to store temoporary files generated by db like proxies
     */
    public function getProxyDir(): ?string
    {
        return $this->proxyDir;
    }

    /**
     *
     * @param string|null $proxyDir ?where to store temporary files generated by db like proxies
     */
    public function setProxyDir(?string $proxyDir)
    {
        $this->proxyDir = $proxyDir;
    }
}
