<?php

namespace IZON\DB;

use Doctrine\Common\EventManager;
use Doctrine\DBAL\Configuration;
use Doctrine\DBAL\Statement;

/**
 * raw connection to db
 * modeled after Doctrine\DBAL\Driver\Connection
 */
interface ConnectionInterface
{
    /**
     * @return EventManager
     */
    public function getEventManager();

    /**
     * Gets the Configuration used by the Connection.
     * @return Configuration
     */
    public function getConfiguration();

    public function prepare(string $sql): Statement;
}
