<?php


namespace IZON\DB\Behaviour\SoftDelete;

use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\Exception\ORMException;

/**
 * Class SoftDeleteSubscriber
 * @package IZON\DB\Behaviour\SoftDelete
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class SoftDeleteSubscriber implements EventSubscriber
{
    /**
     * @return string[]
     */
    public function getSubscribedEvents()
    {
        return [
            Events::onFlush
        ];
    }

    /**
     * @param OnFlushEventArgs $args
     * @throws ORMException
     */
    public function onFlush(OnFlushEventArgs $args)
    {
        $objectManager = $args->getObjectManager();
        $uow = $objectManager->getUnitOfWork();
        //        $evm = $objectManager->getEventManager();

        //getScheduledDocumentDeletions
        foreach ($uow->getScheduledEntityDeletions() as $object) {
            if (
                !is_a($object, SoftDeletable::class)
                || (method_exists($object, 'isSoftDelete') && !$object->isSoftDelete())
            ) {
                continue;
            }
            $meta = $objectManager->getClassMetadata(get_class($object));
            $propertyAccessor = $meta->getPropertyAccessor('deleted');
            $oldValue = $propertyAccessor->getValue($object);
            $propertyAccessor->setValue($object, true);

            $objectManager->persist($object);
            $uow->propertyChanged($object, 'deleted', $oldValue, true);
            $uow->scheduleExtraUpdate(
                $object,
                [
                    'deleted' => [$oldValue, false],
                ]
            );
        }
    }
}
