<?php


namespace IZON\DB\Behaviour\SoftDelete;

use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query\Filter\SQLFilter;

/**
 * Class SoftDeleteFilter
 * @package IZON\DB\Behaviour\SoftDelete
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class SoftDeleteFilter extends SQLFilter
{
    /**
     * @param ClassMetadata $targetEntity
     * @param string $targetTableAlias
     * @return string
     */
    public function addFilterConstraint(ClassMetadata $targetEntity, $targetTableAlias): string
    {
        $isDeletable = $targetEntity->reflClass->implementsInterface(SoftDeletable::class);

        if (!$isDeletable) {
            return "";
        }
        return "$targetTableAlias.deleted = 0";
    }
}
