<?php


namespace IZON\DB\Behaviour;

use Doctrine\Common\EventSubscriber;

abstract class AbstractBehaviour implements BehaviourInterface
{
    protected ?EventSubscriber $eventSubscriber = null;

    protected ?string $sqlFilter = null;

    /**
     * @var array<string, mixed>
     */
    protected array $filterParameters = [];

    /**
     * @return EventSubscriber|null
     */
    public function getEventSubscriber(): ?EventSubscriber
    {
        return $this->eventSubscriber;
    }

    /**
     * {@inheritDoc}
     */
    public function getSQLFilter(): ?string
    {
        return $this->sqlFilter;
    }

    /**
     * @return array
     */
    public function getFilterParameters(): array
    {
        return $this->filterParameters;
    }
}
