<?php
namespace IZON\DB\Paginator;

/**
 * strankovac vysledku, ktery obsahuje pozadovanou stranku (jeji prvky)
 * pocet stranek, kolikata stranka to je atd.
 */
class PageContent implements PageContentInterface {
	
	/**
	 * kompletni mnozstli vysledku bez strankovani
	 */
	protected  $totalCount;
	
	/**
	 * zadana velikost stranky, pro kterou se melo strankovat
	 */
	protected $maxPageSize;
	
	/**
	 * prvky prave aktivni stranky
	 */
	protected $page;
	
	/**
	 * indexy jednotlivych stranek
	 */
	protected $pageIndices;


	public function __construct($totalCount, $maxPageSize, $page) {
 		$this->totalCount = $totalCount;
 		$this->maxPageSize = $maxPageSize;
 		$this->page = $page;
		
                $this->pageIndices = [];
		
 		if($this->totalCount != 0 && $this->maxPageSize != 0) {
                    for($i = 0; $i <= $totalCount; $i=$i+$maxPageSize) {
                        $this->pageIndices[] = $i;
                    }
 		} else {
                    $this->pageIndices[] = 0;
 		}
	}

	public function getPage(): array {
            return $this->page;
	}

	public function getMaxPageSize() {
            return $this->maxPageSize;
	}

	public function getTotalCount(): int {
            return $this->totalCount;
	}

	public function getPageIndices() {
            return $this->pageIndices;
	}
	
//	public void setTotalCount(int totalCount) {
//		this.totalCount = totalCount;
//	}

	/**
	 * vraci pocet stranek pro dany pocet zaznamu na stranku
	 * @param recordsPerPage
	 * @return
	 */
//	public int getPagesCount(int recordsPerPage) {
//		int pagesCout = totalCount/recordsPerPage;
//		if(totalCount%recordsPerPage != 0) { // je treba pridat 1 stranky pro zbile, kteri nenaplni celou stranku
//			pagesCout++;
//		}
//		if(pagesCout == 0) { // musi byt aspon 1 stranka
//			pagesCout = 1;
//		}
//		return pagesCout;
//	}
}
