<?php


namespace IZON\DB\Extensions;


use Doctrine\ORM\Configuration;
use IZON\DB\Extensions\Functions\Acos;
use IZON\DB\Extensions\Functions\Asin;
use IZON\DB\Extensions\Functions\Cos;
use IZON\DB\Extensions\Functions\Sin;

class ArithmeticFunctionExtension implements FunctionExtensionInterface {

    public function register(Configuration $configuration): void {
        $configuration->addCustomStringFunction('SIN', Sin::class);
        $configuration->addCustomStringFunction('COS', Cos::class);
        $configuration->addCustomStringFunction('ASIN', Asin::class);
        $configuration->addCustomStringFunction('ACOS', Acos::class);
    }

}
