<?php


namespace IZON\DB\Behaviour\SoftDelete;


use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Events;

/**
 * Class SoftDeleteSubscriber
 * @package IZON\DB\Behaviour\SoftDelete
 * @author Lukáš Linhart <linhart@izon.cz>
 */
class SoftDeleteSubscriber implements EventSubscriber {
    /**
     * @return array|string[]
     */
    public function getSubscribedEvents() {
        return [
            Events::onFlush
        ];
    }

    /**
     * @param OnFlushEventArgs $args
     * @throws \Doctrine\ORM\ORMException
     */
    public function onFlush(OnFlushEventArgs $args) {
        $entityManager = $args->getEntityManager();
        $uow = $entityManager->getUnitOfWork();
        $evm = $entityManager->getEventManager();

        //getScheduledDocumentDeletions
        foreach($uow->getScheduledEntityDeletions() as $object) {
            if(!is_a($object, SoftDeletable::class) || (method_exists($object, 'isSoftDelete') && !$object->isSoftDelete())) {
                continue;
            }
            $meta = $entityManager->getClassMetadata(get_class($object));
            $reflProp = $meta->getReflectionProperty('deleted');
            $oldValue = $reflProp->getValue($object);
            $reflProp->setValue($object, true);

            $entityManager->persist($object);
            $uow->propertyChanged($object, 'deleted', $oldValue, true);
            $uow->scheduleExtraUpdate(
                $object,
                [
                    'deleted' => array($oldValue, false),
                ]
            );
        }
    }

}
