<?php

namespace IZON\DB\Logger;

use Doctrine\DBAL\Logging\SQLLogger;
use Psr\Log\LoggerInterface;


/**
 * converst SQLLogger interface call to psr LoggerInterface calls
 * @author lukas
 */
class PsrSQLLogger implements SQLLogger {

    /**
     * @var LoggerInterface
     */
    protected $logger;


    function __construct(LoggerInterface $logger) {
        $this->logger = $logger;
    }

    public function startQuery($sql, ?array $params = null, ?array $types = null): void {
        $message = $sql . PHP_EOL;
        $context = [];
        if ($params) {
            $context['params'] = $params;
        }

        if ($types) {
            $context['types'] = $types;
        }

        $this->logger->info($message, $context);
    }

    public function stopQuery(): void {
        
    }
}
