<?php

namespace IZON\DB\Reflection\DocBlock\Tags;

use InvalidArgumentException;
use phpDocumentor\Reflection\DocBlock\DescriptionFactory;
use phpDocumentor\Reflection\DocBlock\Tags\BaseTag;
use phpDocumentor\Reflection\DocBlock\Tags\Factory\StaticMethod;
use phpDocumentor\Reflection\Type;
use phpDocumentor\Reflection\TypeResolver;
use phpDocumentor\Reflection\Types\Context as TypeContext;
use phpDocumentor\Reflection\Types\Void_;
use Webmozart\Assert\Assert;

/**
 * Reflection class for an {@}method in a Docblock.
 */
class Column extends BaseTag implements StaticMethod {
    
    protected $name = 'Column';

    /** @var string */
    protected $type;

    public function __construct(
        $type
    ) {
        $this->type  = $type;
    }

    /**
     * {@inheritdoc}
     */
    public static function create(
        $body,
        TypeResolver $typeResolver = null,
        DescriptionFactory $descriptionFactory = null,
        TypeContext $context = null
    ) {
//        Assert::stringNotEmpty($body);
        Assert::allNotNull([ $typeResolver, $descriptionFactory ]);

        // 1. none or more whitespace
        // 2. optionally the keyword "static" followed by whitespace
        // 3. optionally a word with underscores followed by whitespace : as
        //    type for the return value
        // 4. then a word with underscores, followed by ( and any character
        //    until a ) and whitespace : as method name with signature
        // 5. any remaining text : as description
        if (!preg_match(
            '/^
                # Arguments
                \(([^\)]*)\)
                # rest
                .*
            $/sux',
            $body,
            $matches
        )) {
            return new static(null);
        }
        
        $type = null;
        $params = explode(',', $matches[1]);
        foreach($params as $param) {
            $param = trim($param);
            if( \IZON\String\startsWith($param, 'type') ) {
                $paramExploded = explode('=', $param);
                $type = $paramExploded[1];
            }
        }
        
        return new static($type);
    }

    public function getType() {
        return $this->type;
    }
    
    public function __toString() {
        return $this->type;
    }
}
