<?php

namespace IZON\DB\QueryParams;

use IZON\DB\Exceptions\DBException;

/**
 * Defines order by part of query
 */
class OrderBy {

    const ORDER_ASC = 'ASC';

    const ORDER_DESC = 'DESC';

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $type;


    public function __construct(string $name, string $type) {
        $this->name = $name;
        $this->type = $type;
    }

    /**
     * @return string
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * @return string OrderBy::ORDER_ASC|OrderBy::ORDER_DESC
     */
    public function getType(): string {
        return $this->type;
    }

    public static function reverse(string $type) {
        if($type != self::ORDER_ASC || $type != self::ORDER_DESC) {
            throw new DBException("Unsupported order '$type', can not reverse it.");
        }
        return $type === self::ORDER_ASC ? self::ORDER_DESC : self::ORDER_ASC;
    }
}
