<?php
namespace IZON\DB\Extensions\Functions;

use Doctrine\ORM\Query\Lexer;
use Doctrine\ORM\Query\Parser;
use Doctrine\ORM\Query\SqlWalker;

abstract class BaseUnaryArithmeticFunction extends \Doctrine\ORM\Query\AST\Functions\FunctionNode {

    protected $arithmeticExpression;

    protected $operation;

    public function getSql(SqlWalker $sqlWalker) {
        return $this->operation.'('.$sqlWalker->walkSimpleArithmeticExpression(
                $this->arithmeticExpression
            ).')';
    }

    public function parse(Parser $parser) {
        $parser->match(Lexer::T_IDENTIFIER);
        $parser->match(Lexer::T_OPEN_PARENTHESIS);
        $this->arithmeticExpression = $parser->SimpleArithmeticExpression();
        $parser->match(Lexer::T_CLOSE_PARENTHESIS);
    }


}
