<?php

namespace IZON\DB\Utils;

use Doctrine\Common\Collections\Collection;

/**
 * utils for working with doctrine Collections
 * @package IZON\DB\Utils
 */
class CollectionUtils {

    /**
     * adds all elements from $source to $destination
     * @param Collection $destination
     * @param iterable $source
     */
    public static function addAll(Collection $destination, iterable $source): void {
        foreach($source as $sourceItem) {
            $destination->add($sourceItem);
        }
    }

    /**
     * replaces all elements in $destination with elements from $source
     * @param Collection $destination
     * @param iterable $source
     */
    public static function replaceAll(Collection $destination, iterable $source): void {
        $destination->clear();
        self::addAll($destination, $source);
    }
}