<?php


namespace IZON\DB\Extensions\Functions;


use Doctrine\ORM\Query\AST\Functions\FunctionNode;
use Doctrine\ORM\Query\Lexer;
use Doctrine\ORM\Query\Parser;
use Doctrine\ORM\Query\SqlWalker;

class StringEmpty extends FunctionNode {

    public $string;

    public function getSql(SqlWalker $sqlWalker) {
        return 'LENGTH('.$sqlWalker->walkStringPrimary($this->string).') = 0';
    }

    public function parse(Parser $parser) {
        $parser->match(Lexer::T_IDENTIFIER);
        $parser->match(Lexer::T_OPEN_PARENTHESIS);
        $this->string = $parser->StringPrimary();
        $parser->match(Lexer::T_CLOSE_PARENTHESIS);
    }
}
