<?php

namespace IZON\DB\Reflection;

use IZON\DB\Reflection\DocBlock\Tags\Column;
use IZON\DB\Reflection\DocBlock\Tags\Method;
use phpDocumentor\Reflection\DocBlock\Tags\Method as DocBlockMethod;
use phpDocumentor\Reflection\DocBlockFactory;
use phpDocumentor\Reflection\Types\ContextFactory;
use ReflectionClass as PHPReflectionClass;
use IZON\DB\Exceptions\DBException;

/**
 *
 */
class ReflectionClass {

    protected PHPReflectionClass $reflectionClass;

    protected static ?ContextFactory $contextFactory = null;

    protected static ?DocBlockFactory $docBlockFactory = null;

    /**
     *
     * @param string|PHPReflectionClass $class
     */
    public function __construct($class) {
        if( $class instanceof PHPReflectionClass ) {
            $this->reflectionClass = $class;
        } else if( is_string($class) ) {
            $this->reflectionClass = new PHPReflectionClass($class);
        } else {
            throw new DBException('Uscupported $class parameter '. $class);
        }
    }

    public function getPropertyColumnTagType($porpertyName) {
        $propertyReflection = $this->reflectionClass->getProperty($porpertyName);
        if( empty( $propertyReflection->getDocComment() ) ) {
            return [];
        }

        $docblock = $this->getDocBlockFactory()->create(
            $propertyReflection->getDocComment(),
            $this->getContextFactory()->createFromReflector($this->reflectionClass)
        );

        /* @var $methodTags DocBlock\Tags\Column[] */
        $columnTags = $docblock->getTagsByName('Column');
        if( count($columnTags) > 0 ) {
            return $columnTags[0]->getType();
        }
        return null;
    }


    /**
     *
     * @return ReflectionMethod[]
     */
    public function getDocBlockMethods(): array {
        if( empty($this->reflectionClass->getDocComment()) ) {
            return [];
        }

        $docblock = $this->getDocBlockFactory()->create(
            $this->reflectionClass->getDocComment(),
            $this->getContextFactory()->createFromReflector($this->reflectionClass)
        );

        /* @var $methodTags DocBlockMethod[] */
        $methodTags = $docblock->getTagsByName('method');

        $methodReflections = [];
        foreach($methodTags as $methodTag) {
            $parameters = [];
            foreach($methodTag->getArguments() as $argument) {
                /* @var $parameter ReflectionParameter */
                $parameter = new ReflectionParameter($argument['name']);
                $parameters[] = $parameter;
            }
            $methodReflection = new ReflectionMethod($methodTag->getMethodName(), $parameters);

            $methodReflections[] = $methodReflection;
        }

        return $methodReflections;
    }

    protected function getContextFactory() {
        if( self::$contextFactory === null ) {
            self::$contextFactory = new ContextFactory();
        }
        return self::$contextFactory;
    }

    protected function getDocBlockFactory() {
        if( self::$docBlockFactory === null ) {
            self::$docBlockFactory = DocBlockFactory::createInstance([
                'method' => Method::class,
                'Column' => Column::class
            ]);
        }
        return self::$docBlockFactory;
    }
}
