<?php


namespace IZON\DB\Behaviour;


use Doctrine\Common\EventSubscriber;

abstract class AbstractBehaviour implements BehaviourInterface {
    /**
     * @var EventSubscriber|null
     */
    protected $eventSubscriber;
    /**
     * @var string|null
     */
    protected $sqlFilter;
    /**
     * @var array
     */
    protected $filterParameters = [];

    /**
     * @return EventSubscriber|null
     */
    public function getEventSubscriber(): ?EventSubscriber {
        return $this->eventSubscriber;
    }

    /**
     * {@inheritDoc}
     */
    public function getSQLFilter(): ?string {
        return $this->sqlFilter;
    }

    /**
     * @return array
     */
    public function getFilterParameters(): array {
        return $this->filterParameters;
    }


}
